-- Generated by tools/imgui_upgrader/build_enums.lua

local ImGuiTableColumnFlags_None                 = 0
local ImGuiTableColumnFlags_Disabled             = 1         -- 1 << 0
local ImGuiTableColumnFlags_DefaultHide          = 2         -- 1 << 1
local ImGuiTableColumnFlags_DefaultSort          = 4         -- 1 << 2
local ImGuiTableColumnFlags_WidthStretch         = 8         -- 1 << 3
local ImGuiTableColumnFlags_WidthFixed           = 16        -- 1 << 4
local ImGuiTableColumnFlags_NoResize             = 32        -- 1 << 5
local ImGuiTableColumnFlags_NoReorder            = 64        -- 1 << 6
local ImGuiTableColumnFlags_NoHide               = 128       -- 1 << 7
local ImGuiTableColumnFlags_NoClip               = 256       -- 1 << 8
local ImGuiTableColumnFlags_NoSort               = 512       -- 1 << 9
local ImGuiTableColumnFlags_NoSortAscending      = 1024      -- 1 << 10
local ImGuiTableColumnFlags_NoSortDescending     = 2048      -- 1 << 11
local ImGuiTableColumnFlags_NoHeaderLabel        = 4096      -- 1 << 12
local ImGuiTableColumnFlags_NoHeaderWidth        = 8192      -- 1 << 13
local ImGuiTableColumnFlags_PreferSortAscending  = 16384     -- 1 << 14
local ImGuiTableColumnFlags_PreferSortDescending = 32768     -- 1 << 15
local ImGuiTableColumnFlags_IndentEnable         = 65536     -- 1 << 16
local ImGuiTableColumnFlags_IndentDisable        = 131072    -- 1 << 17
local ImGuiTableColumnFlags_IsEnabled            = 16777216  -- 1 << 24
local ImGuiTableColumnFlags_IsVisible            = 33554432  -- 1 << 25
local ImGuiTableColumnFlags_IsSorted             = 67108864  -- 1 << 26
local ImGuiTableColumnFlags_IsHovered            = 134217728 -- 1 << 27

imgui.TableColumnFlags = {
	None                 = ImGuiTableColumnFlags_None,
	Disabled             = ImGuiTableColumnFlags_Disabled,             -- Overriding/master disable flag: hide column, won't show in context menu (unlike calling TableSetColumnEnabled() which manipulates the user accessible state)
	DefaultHide          = ImGuiTableColumnFlags_DefaultHide,          -- Default as a hidden/disabled column.
	DefaultSort          = ImGuiTableColumnFlags_DefaultSort,          -- Default as a sorting column.
	WidthStretch         = ImGuiTableColumnFlags_WidthStretch,         -- Column will stretch. Preferable with horizontal scrolling disabled (default if table sizing policy is _SizingStretchSame or _SizingStretchProp).
	WidthFixed           = ImGuiTableColumnFlags_WidthFixed,           -- Column will not stretch. Preferable with horizontal scrolling enabled (default if table sizing policy is _SizingFixedFit and table is resizable).
	NoResize             = ImGuiTableColumnFlags_NoResize,             -- Disable manual resizing.
	NoReorder            = ImGuiTableColumnFlags_NoReorder,            -- Disable manual reordering this column, this will also prevent other columns from crossing over this column.
	NoHide               = ImGuiTableColumnFlags_NoHide,               -- Disable ability to hide/disable this column.
	NoClip               = ImGuiTableColumnFlags_NoClip,               -- Disable clipping for this column (all NoClip columns will render in a same draw command).
	NoSort               = ImGuiTableColumnFlags_NoSort,               -- Disable ability to sort on this field (even if ImGuiTableFlags_Sortable is set on the table).
	NoSortAscending      = ImGuiTableColumnFlags_NoSortAscending,      -- Disable ability to sort in the ascending direction.
	NoSortDescending     = ImGuiTableColumnFlags_NoSortDescending,     -- Disable ability to sort in the descending direction.
	NoHeaderLabel        = ImGuiTableColumnFlags_NoHeaderLabel,        -- TableHeadersRow() will not submit label for this column. Convenient for some small columns. Name will still appear in context menu.
	NoHeaderWidth        = ImGuiTableColumnFlags_NoHeaderWidth,        -- Disable header text width contribution to automatic column width.
	PreferSortAscending  = ImGuiTableColumnFlags_PreferSortAscending,  -- Make the initial sort direction Ascending when first sorting on this column (default).
	PreferSortDescending = ImGuiTableColumnFlags_PreferSortDescending, -- Make the initial sort direction Descending when first sorting on this column.
	IndentEnable         = ImGuiTableColumnFlags_IndentEnable,         -- Use current Indent value when entering cell (default for column 0).
	IndentDisable        = ImGuiTableColumnFlags_IndentDisable,        -- Ignore current Indent value when entering cell (default for columns > 0). Indentation changes _within_ the cell will still be honored.
	IsEnabled            = ImGuiTableColumnFlags_IsEnabled,            -- Status: is enabled == not hidden by user/api (referred to as "Hide" in _DefaultHide and _NoHide) flags.
	IsVisible            = ImGuiTableColumnFlags_IsVisible,            -- Status: is visible == is enabled AND not clipped by scrolling.
	IsSorted             = ImGuiTableColumnFlags_IsSorted,             -- Status: is currently part of the sort specs
	IsHovered            = ImGuiTableColumnFlags_IsHovered,            -- Status: is hovered by mouse
}
